<?php

namespace App\Controller\Domain\backend;

use App\Repository\PartnerRepository;
use App\Repository\PostRepository;
use App\Repository\StationRepository;
use App\Service\StatisticsService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/admin/')]
class DashboardController extends AbstractController
{
    private StatisticsService $statisticsService;
    public function __construct(StatisticsService $statisticsService){
        $this->statisticsService = $statisticsService;
    }
    #[Route('dashboard', name: 'back.dashboard')]
    public function index(PartnerRepository $partnerRepository,PostRepository $postRepository, StationRepository $stationRepository): Response
    {
        $partners = $partnerRepository->findAll();
        $posts = $postRepository->findAll();
        $stations = $stationRepository->findAll();
        $statistiques = $this->statisticsService->getAllStatistics();

        return $this->render('domain/backend/dashboard/index.html.twig', [
            'statistiques' => $statistiques['links'],
            'posts' => $posts,
            'partners' => $partners,
            'stations' => $stations,
        ]);
    }
}
