<?php

namespace App\Controller\Domain\backend;

use App\Entity\Param;
use App\Form\ParamType;
use App\Helpers\Utility;
use App\Repository\ParamRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/admin/param', name: 'back.param.')]
final class ParamController extends AbstractController
{
    private string $basePath = "uploads/images/params/";

    #[Route(name: 'index', methods: ['GET'])]
    public function index(ParamRepository $paramRepository): Response
    {
        return $this->render('domain/backend/param/index.html.twig', [
            'params' => $paramRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager, ParamRepository $paramRepository): Response
    {
        $param = $paramRepository->findAll();
        if(count($param) >= 1) {
            return $this->redirectToRoute("back.param.edit", parameters: ['id' => $param[0]->getId()]);
        }
        $param = new Param();
        $form = $this->createForm(ParamType::class, $param);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $imageFile = $form->get('image')->getData();
            $fileStored = Utility::uploadFile($imageFile, $this->getParameter('images_directory'), "params",1170, 227);
            if ($fileStored) {
                $param->setImage($this->basePath .$fileStored);
            }
            $entityManager->persist($param);
            $entityManager->flush();

            return $this->redirectToRoute('back.param.index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('domain/backend/param/new.html.twig', [
            'param' => $param,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'show', methods: ['GET'])]
    public function show(Param $param): Response
    {
        return $this->render('domain/backend/param/show.html.twig', [
            'param' => $param,
        ]);
    }

    #[Route('/{id}/edit', name: 'edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Param $param, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(ParamType::class, $param);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $imageFile = $form->get('image')->getData();
            $fileStored = Utility::uploadFile($imageFile, $this->getParameter('images_directory'), "params",1170, 227);
            if ($fileStored) {
                $param->setImage($this->basePath .$fileStored);
            }
            $entityManager->flush();

            return $this->redirectToRoute('back.param.index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('domain/backend/param/edit.html.twig', [
            'param' => $param,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'delete', methods: ['POST'])]
    public function delete(Request $request, Param $param, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$param->getId(), $request->getPayload()->getString('_token'))) {
            $entityManager->remove($param);
            $entityManager->flush();
        }

        return $this->redirectToRoute('back.param.index', [], Response::HTTP_SEE_OTHER);
    }
}
