<?php

namespace App\Controller\Domain\frontend;

use App\Entity\Comment;
use App\Form\CommentType;
use App\Repository\CategoryRepository;
use App\Repository\PostRepository;
use App\Repository\TagRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/post', name: 'front.')]
class PostController extends AbstractController
{
    #[Route('', name: 'post')]
    public function index(): Response
    {
        return $this->render('domain/frontend/post/index.html.twig', [
            'controller_name' => 'HomeController',
        ]);
    }

    #[Route('/{slug}', name: 'post.details')]
    public function postDetails(
        $slug,
        PostRepository $postRepository,
        CategoryRepository $categoryRepository,
        Request $request,
        EntityManagerInterface $entityManager,
        TagRepository $tagRepository,
    ): Response
    {
        $categories = $categoryRepository->findAll();
        $tags = $tagRepository->findAll();
        $post = $postRepository->findOneBy(['slug' => $slug]);
        if ($post == null) {
            return $this->redirectToRoute('front.home');
        }

        $postsResents = $postRepository->findBy([], ['datePublication' => 'DESC'], limit: 3);

        $comment = new Comment();
        $form = $this->createForm(CommentType::class, $comment);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $comment->setPost($post);
            $comment->setCreatedAt(new \DateTimeImmutable());
            $entityManager->persist($comment);
            $entityManager->flush();
            $this->addFlash('success', "Commentaire ajouté avec succès");
            return $this->redirectToRoute('front.post.details', ['slug' => $post->getSlug()]);
        }
        return $this->render('domain/frontend/post/details.html.twig', [
            'post' => $post,
            'categories' => $categories,
            'form' => $form->createView(),
            'postsResents' => $postsResents,
            'tags' => $tags,
        ]);
    }
}
