<?php

namespace App\Entity;

use App\Repository\ParamRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ParamRepository::class)]
class Param
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private ?int $countStation = null;

    #[ORM\Column]
    private ?int $countCamion = null;

    #[ORM\Column]
    private ?int $countCalabarator = null;

    #[ORM\Column]
    private ?int $experienceYear = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $image = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCountStation(): ?int
    {
        return $this->countStation;
    }

    public function setCountStation(int $countStation): static
    {
        $this->countStation = $countStation;

        return $this;
    }

    public function getCountCamion(): ?int
    {
        return $this->countCamion;
    }

    public function setCountCamion(int $countCamion): static
    {
        $this->countCamion = $countCamion;

        return $this;
    }

    public function getCountCalabarator(): ?int
    {
        return $this->countCalabarator;
    }

    public function setCountCalabarator(int $countCalabarator): static
    {
        $this->countCalabarator = $countCalabarator;

        return $this;
    }

    public function getExperienceYear(): ?int
    {
        return $this->experienceYear;
    }

    public function setExperienceYear(int $experienceYear): static
    {
        $this->experienceYear = $experienceYear;

        return $this;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): static
    {
        $this->image = $image;

        return $this;
    }
}
