<?php

namespace App\Entity;

use App\EventSubscriber\SlugSubscriber;
use App\Repository\ProjectRepository;
use App\Trait\SluggableTrait;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;

#[ORM\EntityListeners([SlugSubscriber::class])]
#[ORM\Entity(repositoryClass: ProjectRepository::class)]
class Project
{
    use SluggableTrait;
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $image = null;

    #[ORM\Column(length: 255)]
    private ?string $description = null;

    #[ORM\Column(type: 'datetime_immutable', nullable: true)]
    private ?\DateTimeImmutable $publishedAt = null;

    /**
     * @var Collection<int, ProjectMedia>
     */
    #[ORM\OneToMany(targetEntity: ProjectMedia::class, mappedBy: 'project', cascade: ['persist', 'remove'])]
    private Collection $projectMedia;

    public function __construct()
    {
        $this->projectMedia = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): static
    {
        $this->image = $image;
        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;
        return $this;
    }

    public function getPublishedAt(): ?\DateTimeImmutable
    {
        return $this->publishedAt;
    }

    public function setPublishedAt(?\DateTimeImmutable $publishedAt): static
    {
        $this->publishedAt = $publishedAt;
        return $this;
    }

    /**
     * @return Collection<int, ProjectMedia>
     */
    public function getProjectMedia(): Collection
    {
        return $this->projectMedia;
    }

    public function addProjectMedia(ProjectMedia $projectMedia): static
    {
        if (!$this->projectMedia->contains($projectMedia)) {
            $this->projectMedia->add($projectMedia);
            $projectMedia->setProject($this);
        }

        return $this;
    }

    public function removeProjectMedia(ProjectMedia $projectMedia): static
    {
        if ($this->projectMedia->removeElement($projectMedia)) {
            // set the owning side to null (unless already changed)
            if ($projectMedia->getProject() === $this) {
                $projectMedia->setProject(null);
            }
        }

        return $this;
    }
}