<?php

namespace App\Service;

class StatisticsService
{
    private array $statistics;
    private string $jsonFile;

    public function __construct(string $projectDir = null)
    {
        // Si projectDir n'est pas fourni, utiliser le répertoire var/ du projet
        $projectDir = $projectDir ?? dirname(__DIR__, 2);

        // Créer le répertoire var/statistics s'il n'existe pas
        $statisticsDir = $projectDir . '/var/statistics';
        if (!is_dir($statisticsDir)) {
            mkdir($statisticsDir, 0777, true);
        }

        $this->jsonFile = $statisticsDir . '/statistics.json';
        $this->loadStatistics();
    }

    private function loadStatistics(): void
    {
        if (!file_exists($this->jsonFile)) {
            $this->statistics = [];
            $this->saveStatistics();
        } else {
            $content = file_get_contents($this->jsonFile);
            $this->statistics = json_decode($content, true) ?? [];
        }
    }

    private function saveStatistics(): void
    {
        file_put_contents($this->jsonFile, json_encode($this->statistics, JSON_PRETTY_PRINT));
    }

    public function incrementLinkClick(string $linkIdentifier): void
    {
        if (!isset($this->statistics['links'][$linkIdentifier])) {
            $this->statistics['links'][$linkIdentifier] = [
                'clicks' => 0,
                'first_click' => time(),
                'last_click' => null
            ];
        }

        $this->statistics['links'][$linkIdentifier]['clicks']++;
        $this->statistics['links'][$linkIdentifier]['last_click'] = time();

        $this->saveStatistics();
    }

    public function getLinkStatistics(string $linkIdentifier): ?array
    {
        return $this->statistics['links'][$linkIdentifier] ?? null;
    }

    public function getAllStatistics(): array
    {
        return $this->statistics;
    }
}